function setup()
{
	if(window.widget)
	{
	}
}


function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button

}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}


function computeMask()
        {
	var inputError = 0;
	var outputError = 0;
    var outputNetworkAddress = 0;
    var outputBroadcastAddress = 0;
	var outputHostsPerSubnet = 0;
	var subnetHosts = 16777214;
    var inputAddress = document.networkCalculator.inputAddress.value;
    var inputMask = document.networkCalculator.inputMask.value;
    var inputMaskBits = document.networkCalculator.inputMaskBits.value;
    inputAddressArray = inputAddress.split(".");
    var oct1 = inputAddressArray[0];
    var oct2 = inputAddressArray[1];
    var oct3 = inputAddressArray[2];
    var oct4 = inputAddressArray[3];        
    var inputErrorMaskBits;
    var snm1;
    var snm2;
    var snm3;
    var snm4;
    if (inputMaskBits < 8) {inputErrorMaskBits = 1}
    if (inputMaskBits >= 8) {snm1 = 255; snm2 = bitsMask((inputMaskBits - 8)); snm3 = 0; snm4 = 0;}
    if (inputMaskBits >= 16) {snm1 = 255; snm2 = 255; snm3 = bitsMask((inputMaskBits - 16)); snm4 = 0;}    
    if (inputMaskBits >= 24) {snm1 = 255; snm2 = 255; snm3 = 255; snm4 = bitsMask((inputMaskBits - 24));}    
    if (inputMaskBits >= 32) {inputErrorMaskBits = 1}
    var nw1 = eval(snm1 & oct1);
    var nw2 = eval(snm2 & oct2);
    var nw3 = eval(snm3 & oct3);
    var nw4 = eval(snm4 & oct4);
    var node1 = eval(~ snm1 & oct1);
    var node2 = eval(~ snm2 & oct2);
    var node3 = eval(~ snm3 & oct3);
    var node4 = eval(~ snm4 & oct4);
	var broad1 = nw1;
    var broad2 = 0;
    var broad3 = 0;
    var broad4 = 0;
 	var inputErrorAddress = inputCheck(oct1);
	if (oct1 <= 0) {inputErrorAddress = inputErrorAddress +1;}
	if (oct1 = "") {inputErrorAddress = inputErrorAddress +1;}
	inputErrorAddress = inputErrorAddress + inputCheck(oct2);
	inputErrorAddress = inputErrorAddress + inputCheck(oct3);
	inputErrorAddress = inputErrorAddress + inputCheck(oct4);
    if ((snm2 == 255) && (snm3 == 255))
                {
                broad2 = nw2;
                broad3 = nw3;
                j = parseInt(nw4);
                i = parseInt(oct4);
                while ((nw4 == j) && i < 256)
                        {
                        i = eval (i + 1);
                        j = eval(snm4 & i);
                        }
                broad4 = eval(i - 1);
		outputHostsPerSubnet = hostsPerSubnet(snm4,24);
		}
        if ((snm2 == 255) && (snm3 != 255))
                {
                broad2 = nw2;
                j = parseInt(nw3);
                i = parseInt(oct3);
                while ((nw3 == j) && i < 256)
                        {
                        i = eval (i + 1);
                        j = eval(snm3 & i);
                        }
                broad3 = eval(i - 1);
                broad4 = 255;
		outputHostsPerSubnet = hostsPerSubnet(snm3,16);
               }
        if (snm2 != 255)
                {
                j = parseInt(nw2);
                i = parseInt(oct2);
                while ((nw2 == j) && i < 256)
                        {
                        i = eval (i + 1);
                        j = eval(snm2 & i);
                        }
                broad2 = eval(i - 1);
                broad3 = 255;
                broad4 = 255;
		outputHostsPerSubnet = hostsPerSubnet(snm2,8);
                }
	var outputNetworkAddress = nw1 + '.' + nw2 + '.' + nw3 + '.' + nw4;
	var outputBroadcastAddress = broad1 + '.' + broad2 + '.' + broad3 + '.' + broad4;
	var outputMask = snm1 + '.' + snm2 + '.' + snm3 + '.' + snm4;
	if (inputErrorAddress >= 1) {outputError = 1; }
	if (inputAddress == "") {outputError = 1;}
	if (nw1 == 0) {outputError = 1;}
	if (broad1 == 0) {outputError = 1;}
	if (inputErrorMaskBits > 0) {outputError = 1;}
	if (outputError > 0)
		{
		outputNetworkAddress = "";
		outputBroadcastAddress = "";
		outputHostsPerSubnet = "";
		outputMask = "";
		}
	document.networkCalculator.inputMask.value = outputMask;
	document.networkCalculator.outputNetworkAddress.value = outputNetworkAddress;
	document.networkCalculator.outputBroadcastAddress.value = outputBroadcastAddress;
	document.networkCalculator.outputHostsPerSubnet.value = outputHostsPerSubnet;
        }
        
function computeBits()
        {
	var inputError = 0;
	var outputError = 0;
    var outputNetworkAddress = 0;
    var outputBroadcastAddress = 0;
	var outputHostsPerSubnet = 0;
	var subnetHosts = 16777214;
    var inputAddress = document.networkCalculator.inputAddress.value;
    var inputMask = document.networkCalculator.inputMask.value;
    var inputMaskBits = document.networkCalculator.inputMaskBits.value;
    inputAddressArray = inputAddress.split(".");
    var oct1 = inputAddressArray[0];
    var oct2 = inputAddressArray[1];
    var oct3 = inputAddressArray[2];
    var oct4 = inputAddressArray[3];        
    inputMaskArray = inputMask.split(".");
    var snm1 = inputMaskArray[0];
    var snm2 = inputMaskArray[1];
    var snm3 = inputMaskArray[2];
    var snm4 = inputMaskArray[3];
    var nw1 = eval(snm1 & oct1);
    var nw2 = eval(snm2 & oct2);
    var nw3 = eval(snm3 & oct3);
    var nw4 = eval(snm4 & oct4);
    var node1 = eval(~ snm1 & oct1);
    var node2 = eval(~ snm2 & oct2);
    var node3 = eval(~ snm3 & oct3);
    var node4 = eval(~ snm4 & oct4);
	var broad1 = nw1;
    var broad2 = 0;
    var broad3 = 0;
    var broad4 = 0;
 	var inputErrorAddress = inputCheck(oct1);
	if (oct1 <= 0) {inputErrorAddress = inputErrorAddress +1;}
	if (oct1 = "") {inputErrorAddress = inputErrorAddress +1;}
	inputErrorAddress = inputErrorAddress + inputCheck(oct2);
	inputErrorAddress = inputErrorAddress + inputCheck(oct3);
	inputErrorAddress = inputErrorAddress + inputCheck(oct4);
 	var inputErrorMask = inputCheck(snm1);
	inputErrorMask = inputErrorMask + inputCheck(snm2);
	inputErrorMask = inputErrorMask + inputCheck(snm3);
	inputErrorMask = inputErrorMask + inputCheck(snm4);
	if (snm1 < 255) {inputErrorMask = inputErrorMask + 1;}
	if (snm2 < snm3) {inputErrorMask = inputErrorMask + 1;}
	if (snm3 < snm4) {inputErrorMask = inputErrorMask + 1;}
 	if (snm4 == 255) {inputErrorMask = inputErrorMask + 1;}
	if ((snm2 == 0) && (snm3 > 0)) {inputErrorMask = inputErrorMask + 1;}
	if ((snm2 == 0) && (snm4 > 0)) {inputErrorMask = inputErrorMask + 1;}
	if ((snm3 == 0) && (snm4 > 0)) {inputErrorMask = inputErrorMask + 1;}
	if ((snm3 < 255) && (snm2 < 255) && (snm3 != 0)) {inputErrorMask = inputErrorMask + 1;}
	if ((snm4 < 255) && (snm3 < 255) && (snm4 != 0)) {inputErrorMask = inputErrorMask + 1;}
	if ((snm4 < 255) && (snm2 < 255) && (snm4 != 0)) {inputErrorMask = inputErrorMask + 1;}
	if (snm2 < snm3) {inputErrorMask = inputErrorMask + 1;}
	var invalidSubnet = 1
        if ((snm2 == 255) && (snm3 == 255))
                {
		isValidSubnet = checkSubnet(snm4);
		if (isValidSubnet == 1) {invalidSubnet = 0;}
                broad2 = nw2;
                broad3 = nw3;
                j = parseInt(nw4);
                i = parseInt(oct4);
                while ((nw4 == j) && i < 256)
                        {
                        i = eval (i + 1);
                        j = eval(snm4 & i);
                        }
                broad4 = eval(i - 1);
		outputHostsPerSubnet = hostsPerSubnet(snm4,24);
		outputMaskBits = (maskBits(snm4) + 24);
		}
        if ((snm2 == 255) && (snm3 != 255))
                {
		isValidSubnet = checkSubnet(snm3);
		if (isValidSubnet == 1) {invalidSubnet = 0;}
                broad2 = nw2;
                j = parseInt(nw3);
                i = parseInt(oct3);
                while ((nw3 == j) && i < 256)
                        {
                        i = eval (i + 1);
                        j = eval(snm3 & i);
                        }
                broad3 = eval(i - 1);
                broad4 = 255;
		outputHostsPerSubnet = hostsPerSubnet(snm3,16);
		outputMaskBits = (maskBits(snm3) + 16)
               }
        if (snm2 != 255)
                {
		isValidSubnet = checkSubnet(snm2);
		if (isValidSubnet == 1) {invalidSubnet = 0;}
                j = parseInt(nw2);
                i = parseInt(oct2);
                while ((nw2 == j) && i < 256)
                        {
                        i = eval (i + 1);
                        j = eval(snm2 & i);
                        }
                broad2 = eval(i - 1);
                broad3 = 255;
                broad4 = 255;
		outputHostsPerSubnet = hostsPerSubnet(snm2,8);
		outputMaskBits = (maskBits(snm2) + 8);
                }
	var outputNetworkAddress = nw1 + '.' + nw2 + '.' + nw3 + '.' + nw4;
	var outputBroadcastAddress = broad1 + '.' + broad2 + '.' + broad3 + '.' + broad4;
	if (inputErrorAddress >= 1) {outputError = 1; }
	if (inputErrorMask >= 1)  {outputError = 1; }
	if (inputAddress == "") {outputError = 1;}
	if (inputMask == "") {outputError = 1;}
	if (nw1 == 0) {outputError = 1;}
	if (broad1 == 0) {outputError = 1;}
	if (invalidSubnet == 1) {outputError = 1;}
	if (outputError > 0)
		{
		outputNetworkAddress = "";
		outputBroadcastAddress = "";
		outputHostsPerSubnet = "";
		outputMaskBits = "";
		}
	document.networkCalculator.inputMaskBits.value = outputMaskBits;
	document.networkCalculator.outputNetworkAddress.value = outputNetworkAddress;
	document.networkCalculator.outputBroadcastAddress.value = outputBroadcastAddress;
	document.networkCalculator.outputHostsPerSubnet.value = outputHostsPerSubnet;
        }

function inputCheck(input)
	{
	var returnError = 1;
	if (input <= 255 && input >= 0) {returnError = 0;}
	if (input == "") {returnError = 1;}
	return returnError;
	}

function checkSubnet(input)
	{
	var j = 256;
	var isValid = 0;
	for (i = 1; j >= 128 == true; i = i * 2)
		{
		var j = 256 - i;
		if (input == j) {isValid = 1; return isValid;}
		if (input == 0) {isValid = 1; return isValid;}
      		}   
   	}

function hostsPerSubnet(mask,extrabits)
	{
	var output;
	var bits;
	if (mask == 128) {bits = (1 + extrabits);}
 	if (mask == 192) {bits = (2 + extrabits);}
	if (mask == 224) {bits = (3 + extrabits);}
	if (mask == 240) {bits = (4 + extrabits);}
	if (mask == 248) {bits = (5 + extrabits);}
	if (mask == 252) {bits = (6 + extrabits);}
	if (mask == 254) {bits = (7 + extrabits);}
	if (mask == 0) {bits = extrabits;}
	bits = 32-bits;
	output = (Math.pow(2,bits)- 2);
	return output;
  	}
  	
function maskBits(mask)
	{
	var output;
	var bits;
	if (mask == 128) {bits = 1;}
 	if (mask == 192) {bits = 2;}
	if (mask == 224) {bits = 3;}
	if (mask == 240) {bits = 4;}
	if (mask == 248) {bits = 5;}
	if (mask == 252) {bits = 6;}
	if (mask == 254) {bits = 7;}
	if (mask == 0) {bits = 0;}
	return bits;
  	}
function bitsMask(bits)
	{
	var mask;
	var bits;
	if (bits == 1) {mask = 128;}
 	if (bits == 2) {mask = 192;}
	if (bits == 3) {mask = 224;}
	if (bits == 4) {mask = 240;}
	if (bits == 5) {mask = 248;}
	if (bits == 6) {mask = 252;}
	if (bits == 7) {mask = 254;}
	if (bits == 0) {mask = 0;}
	return mask;
  	}